## load the library
library("Luminescence")

## set the working directory
setwd("/analysis/project_0815")

## definition of analysis parameters
signal.integral <- 1:5
background.integral <- 200:250
position <- 1:20

## import the BIN-file
SAR.data <- readBIN2R("example.BIN")

## analyse the dataset
SAR.results <- Analyse_SAR.OSLdata(input.data = SAR.data,
  signal.integral = signal.integral,
  background.integral = background.integral,
  position = position)

## extract LxTx data and create De-values
De.data <- data.frame(De = NA, De.Error = NA)
for(i in 1:max(position)) {
  data.LxTx <- as.data.frame(
  cbind(SAR.results[[1]][[i]][c(2, 12, 13, 6)]))
  growth.curve <- plot_GrowthCurve(data.LxTx)
  
  ## extract and show De-value and De-error
  De.data[i,] <- as.numeric(growth.curve$De[1:2])
}

## convert seconds to Gray
De.data <- Second2Gray(
  values = De.data,
  dose_rate = c(0.08812, 0.00059),
  method = "gaussian")

## show the resulting matrix
De.data